<?php 
/*
	Plugin Name: Live Composer
	Plugin URI: http://www.livecomposerplugin.com
	Description: Live Composer - Live front-end content management.
	Author: Dany Duchaine and Slobodan Kustrimovic
	Version: 1.1.9
	Author URI: http://livecomposerplugin.com
*/

	/**
	 * Constants
	 */

	define( 'DS_LIVE_COMPOSER_VER', '1.0.6.1' );
	define( 'DS_LIVE_COMPOSER_LOAD_MINIFIED', true );

	define( 'DS_LIVE_COMPOSER_URL', plugin_dir_url( __FILE__ ) );
	define( 'DS_LIVE_COMPOSER_DIR_NAME', dirname( plugin_basename( __FILE__ ) ) );
	define( 'DS_LIVE_COMPOSER_ABS', dirname(__FILE__) );
	define( 'DS_LIVE_COMPOSER_DEV_MODE', false );

	define( 'DSLC_PO_FRAMEWORK_ABS', DS_LIVE_COMPOSER_ABS . '/includes/plugin-options-framework' );
	define( 'DSLC_ST_FRAMEWORK_ABS', DS_LIVE_COMPOSER_ABS . '/includes/single-templates-framework' );
	define( 'DSLC_ROW_SYSTEM_ABS', DS_LIVE_COMPOSER_ABS . '/includes/row-system' );

	load_plugin_textdomain( 'dslc_string', false, DS_LIVE_COMPOSER_DIR_NAME . '/lang/' );

	$dslc_var_image_option_bckp = array();
	$dslc_var_row_options = array();

	/**
	 * Is live composer currently active?
	 */

	if ( isset( $_REQUEST['dslc'] ) && $_REQUEST['dslc'] === 'active' ) {
		$dslc_active = true;
		define( 'DS_LIVE_COMPOSER_ACTIVE', true );
	} else {
		$dslc_active = false;
		define( 'DS_LIVE_COMPOSER_ACTIVE', false );
	}

	/**
	 * Global Variables
	 */

	$dslc_var_modules = array(); // Will hold modules information
	$dslc_var_templates = array(); // Will hold templates information
	$dslc_var_post_options = array(); // Will hold post options information
	$dslc_var_icons = array(); // Will hold available icons array

	$dslc_css_fonts = '';
	$dslc_css_style = '';
	$dslc_googlefonts_array = array();
	$dslc_all_googlefonts_array = array( "ABeeZee","Abel","Abril Fatface","Aclonica","Acme","Actor","Adamina","Advent Pro","Aguafina Script","Akronim","Aladin","Aldrich","Alef","Alegreya","Alegreya SC","Alex Brush","Alfa Slab One","Alice","Alike","Alike Angular","Allan","Allerta","Allerta Stencil","Allura","Almendra","Almendra Display","Almendra SC","Amarante","Amaranth","Amatic SC","Amethysta","Anaheim","Andada","Andika","Annie Use Your Telescope","Anonymous Pro","Antic","Antic Didone","Antic Slab","Anton","Arapey","Arbutus","Arbutus Slab","Architects Daughter","Archivo Black","Archivo Narrow","Arimo","Arizonia","Armata","Artifika","Arvo","Asap","Asset","Astloch","Asul","Atomic Age","Aubrey","Audiowide","Autour One","Average","Average Sans","Averia Gruesa Libre","Averia Libre","Averia Sans Libre","Averia Serif Libre","Bad Script","Balthazar","Bangers","Basic","Baumans","Belgrano","Belleza","BenchNine","Bentham","Berkshire Swash","Bevan","Bigelow Rules","Bigshot One","Bilbo","Bilbo Swash Caps","Bitter","Black Ops One","Bonbon","Boogaloo","Bowlby One","Bowlby One SC","Brawler","Bree Serif","Bubblegum Sans","Bubbler One","Buda","Buenard","Butcherman","Butterfly Kids","Cabin","Cabin Condensed","Cabin Sketch","Caesar Dressing","Cagliostro","Calligraffitti","Cambo","Candal","Cantarell","Cantata One","Cantora One","Capriola","Cardo","Carme","Carrois Gothic","Carrois Gothic SC","Carter One","Caudex","Cedarville Cursive","Ceviche One","Changa One","Chango","Chau Philomene One","Chela One","Chelsea Market","Cherry Cream Soda","Cherry Swash","Chewy","Chicle","Chivo","Cinzel","Cinzel Decorative","Clicker Script","Coda","Coda Caption","Codystar","Combo","Comfortaa","Coming Soon","Concert One","Condiment","Contrail One","Convergence","Cookie","Copse","Corben","Courgette","Cousine","Coustard","Covered By Your Grace","Crafty Girls","Creepster","Crete Round","Crimson Text","Croissant One","Crushed","Cuprum","Cutive","Cutive Mono","Damion","Dancing Script", "Dawning of a New Day","Days One","Delius","Delius Swash Caps","Delius Unicase","Della Respira","Denk One","Devonshire","Didact Gothic","Diplomata","Diplomata SC","Domine","Donegal One","Doppio One","Dorsa","Dosis","Dr Sugiyama","Droid Sans","Droid Sans Mono","Droid Serif","Duru Sans","Dynalight","Eagle Lake","Eater","EB Garamond","Economica","Electrolize","Elsie","Elsie Swash Caps","Emblema One","Emilys Candy","Engagement","Englebert","Enriqueta","Erica One","Esteban","Euphoria Script","Ewert","Exo","Expletus Sans","Fanwood Text","Fascinate","Fascinate Inline","Faster One","Fauna One","Federant","Federo","Felipa","Fenix","Finger Paint","Fjalla One","Fjord One","Flamenco","Flavors","Fondamento","Fontdiner Swanky","Forum","Francois One","Freckle Face","Fredericka the Great","Fredoka One","Fresca","Frijole","Fruktur","Fugaz One","Gabriela","Gafata","Galdeano","Galindo","Gentium Basic","Gentium Book Basic","Geo","Geostar","Geostar Fill","Germania One","GFS Didot","GFS Neohellenic","Gilda Display","Give You Glory","Glass Antiqua","Glegoo","Gloria Hallelujah","Goblin One","Gochi Hand","Gorditas","Goudy Bookletter 1911","Graduate","Grand Hotel","Gravitas One","Great Vibes","Griffy","Gruppo","Gudea","Habibi","Hammersmith One","Hanalei","Hanalei Fill","Handlee","Happy Monkey","Headland One","Henny Penny","Herr Von Muellerhoff","Holtwood One SC","Homemade Apple","Homenaje","Iceberg","Iceland","IM Fell Double Pica","IM Fell Double Pica SC","IM Fell DW Pica","IM Fell DW Pica SC","IM Fell English","IM Fell English SC","IM Fell French Canon","IM Fell French Canon SC","IM Fell Great Primer","IM Fell Great Primer SC","Imprima","Inconsolata","Inder","Indie Flower","Inika","Irish Grover","Istok Web","Italiana","Italianno","Jacques Francois","Jacques Francois Shadow","Jim Nightshade","Jockey One","Jolly Lodger","Josefin Sans","Josefin Slab","Joti One","Judson","Julee","Julius Sans One","Junge","Jura","Just Another Hand","Just Me Again Down Here","Kameron","Karla","Kaushan Script","Kavoon","Keania One","Kelly Slab","Kenia","Kite One","Knewave","Kotta One","Kranky","Kreon","Kristi","Krona One","La Belle Aurore","Lancelot","Lato","League Script","Leckerli One","Ledger","Lekton","Lemon","Libre Baskerville","Life Savers","Lilita One","Lily Script One","Limelight","Linden Hill","Lobster","Lobster Two","Londrina Outline","Londrina Shadow","Londrina Sketch","Londrina Solid","Lora","Love Ya Like A Sister","Loved by the King","Lovers Quarrel","Luckiest Guy","Lusitana","Lustria","Macondo","Macondo Swash Caps","Magra","Maiden Orange","Mako","Marcellus","Marcellus SC","Marck Script","Margarine","Marko One","Marmelad","Marvel","Mate","Mate SC","Maven Pro","McLaren","Meddon","MedievalSharp","Medula One","Megrim","Meie Script","Merienda","Merienda One","Merriweather","Merriweather Sans","Metal Mania","Metamorphous","Metrophobic","Michroma","Milonga","Miltonian","Miltonian Tattoo","Miniver","Miss Fajardose","Modern Antiqua","Molengo","Molle","Monda","Monofett","Monoton","Monsieur La Doulaise","Montaga","Montez","Montserrat","Montserrat Alternates","Montserrat Subrayada","Mountains of Christmas","Mouse Memoirs","Mr Bedfort","Mr Dafoe","Mr De Haviland","Mrs Saint Delafield","Mrs Sheppards","Muli","Mystery Quest","Neucha","Neuton","New Rocker","News Cycle","Niconne","Nixie One","Nobile","Norican","Nosifer","Nothing You Could Do","Noticia Text","Noto Sans","Noto Serif","Nova Cut","Nova Flat","Nova Mono","Nova Oval","Nova Round","Nova Script","Nova Slim","Nova Square","Numans","Nunito","Offside","Old Standard TT","Oldenburg","Oleo Script","Oleo Script Swash Caps","Open Sans","Open Sans Condensed","Oranienbaum","Orbitron","Oregano","Orienta","Original Surfer","Oswald","Over the Rainbow","Overlock","Overlock SC","Ovo","Oxygen","Oxygen Mono","Pacifico","Paprika","Parisienne","Passero One","Passion One","Pathway Gothic One","Patrick Hand","Patrick Hand SC","Patua One","Paytone One","Peralta","Permanent Marker","Petit Formal Script","Petrona","Philosopher","Piedra","Pinyon Script","Pirata One","Plaster","Play","Playball","Playfair Display","Playfair Display SC","Podkova","Poiret One","Poller One","Poly","Pompiere","Poppins","Pontano Sans","Port Lligat Sans","Port Lligat Slab","Prata","Press Start 2P","Princess Sofia","Prociono","Prosto One","PT Mono","PT Sans","PT Sans Caption","PT Sans Narrow","PT Serif","PT Serif Caption","Puritan","Purple Purse","Quando","Quantico","Quattrocento","Quattrocento Sans","Questrial","Quicksand","Quintessential","Qwigley","Racing Sans One","Radley","Raleway","Raleway Dots","Rambla","Rammetto One","Ranchers","Rancho","Rationale","Redressed","Reenie Beanie","Revalia","Ribeye","Ribeye Marrow","Righteous","Risque","Roboto","Roboto Condensed","Roboto Slab","Rochester","Rock Salt","Rokkitt","Romanesco","Ropa Sans","Rosario","Rosarivo","Rouge Script","Ruda","Rufina","Ruge Boogie","Ruluko","Rum Raisin","Ruslan Display","Russo One","Ruthie","Rye","Sacramento","Sail","Salsa","Sanchez","Sancreek","Sansita One","Sarina","Satisfy","Scada","Schoolbell","Seaweed Script","Sevillana","Seymour One","Shadows Into Light","Shadows Into Light Two","Shanti","Share","Share Tech","Share Tech Mono","Shojumaru","Short Stack","Sigmar One","Signika","Signika Negative","Simonetta","Sintony","Sirin Stencil","Six Caps","Skranji","Slackey","Smokum","Smythe","Sniglet","Snippet","Snowburst One","Sofadi One","Sofia","Sonsie One","Sorts Mill Goudy","Source Code Pro","Source Sans Pro","Special Elite","Spicy Rice","Spinnaker","Spirax","Squada One","Stalemate","Stalinist One","Stardos Stencil","Stint Ultra Condensed","Stint Ultra Expanded","Stoke","Strait","Sue Ellen Francisco","Sunshiney","Supermercado One","Swanky and Moo Moo","Syncopate","Tangerine","Tauri","Telex","Tenor Sans","Text Me One","The Girl Next Door","Tienne","Tinos","Titan One","Titillium Web","Trade Winds","Trocchi","Trochut","Trykker","Tulpen One","Ubuntu","Ubuntu Condensed","Ubuntu Mono","Ultra","Uncial Antiqua","Underdog","Unica One","UnifrakturCook","UnifrakturMaguntia","Unkempt","Unlock","Unna","Vampiro One","Varela","Varela Round","Vast Shadow","Vibur","Vidaloka","Viga","Voces","Volkhov","Vollkorn","Voltaire","VT323","Waiting for the Sunrise","Wallpoet","Walter Turncoat","Warnes","Wellfleet","Wendy One","Wire One","Yanone Kaffeesatz","Yellowtail","Yeseva One","Yesteryear","Zeyada" );
	$dslc_should_filter = true;

	/**
	 *  Default Templates
	 */

	$dslc_var_templates['dslc-blog-ex-1'] = array(
		'title' => __( 'Blog Variation 1', 'dslc_string' ),
		'id' => 'dslc-blog-ex-1',
		'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="" border="" bg_color="" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="" bg_video_overlay_opacity="" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="61" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="yes" first="no" size="12"] [dslc_module]YToxODp7czo0OiJzaXplIjtzOjI6IjEyIjtzOjY6ImFtb3VudCI7czoxOiI2IjtzOjE1OiJwYWdpbmF0aW9uX3R5cGUiO3M6ODoibnVtYmVyZWQiO3M6NzoiY29sdW1ucyI7czoxOiI2IjtzOjI1OiJjc3NfbWFpbl9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjMwIjtzOjI3OiJjc3NfbWFpbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiNTAiO3M6MTU6InRpdGxlX2ZvbnRfc2l6ZSI7czoyOiIyNSI7czoyMToiY3NzX3RpdGxlX2ZvbnRfd2VpZ2h0IjtzOjM6IjMwMCI7czoyMToiY3NzX3RpdGxlX2ZvbnRfZmFtaWx5IjtzOjc6IlJhbGV3YXkiO3M6MTc6InRpdGxlX2xpbmVfaGVpZ2h0IjtzOjI6IjM4IjtzOjE3OiJjc3NfZXhjZXJwdF9jb2xvciI7czo3OiIjOTk5OTk5IjtzOjIxOiJjc3NfZXhjZXJwdF9mb250X3NpemUiO3M6MjoiMTYiO3M6MjM6ImNzc19leGNlcnB0X2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoyMzoiY3NzX2V4Y2VycHRfZm9udF9mYW1pbHkiO3M6NDoiTXVsaSI7czoyMzoiY3NzX2V4Y2VycHRfbGluZV9oZWlnaHQiO3M6MjoiMzAiO3M6MTQ6ImV4Y2VycHRfbGVuZ3RoIjtzOjI6IjQwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6MzM7czo5OiJtb2R1bGVfaWQiO3M6OToiRFNMQ19CbG9nIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);

	$dslc_var_templates['dslc-blog-ex-2'] = array(
		'title' => __( 'Blog Variation 2', 'dslc_string' ),
		'id' => 'dslc-blog-ex-2',
		'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="" border="" bg_color="#f7f7f7" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="" bg_video_overlay_opacity="" bg_image_repeat="no-repeat" bg_image_attachment="parallax" bg_image_position="center bottom" bg_image_size="auto" padding="49" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="yes" first="no" size="12"] [dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);

	$dslc_var_templates['dslc-blog-ex-3'] = array(
		'title' => __( 'Blog Variation 3', 'dslc_string' ),
		'id' => 'dslc-blog-ex-3',
		'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="bottom " bg_color="#f7f9fa" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="63" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="no" first="yes" size="8"] [dslc_module]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[/dslc_module] [/dslc_modules_area] [dslc_modules_area last="yes" first="no" size="4"] [dslc_module]YToyMDp7czo0OiJzaXplIjtzOjI6IjEyIjtzOjc6InNpZGViYXIiO3M6MTY6ImRzbGNfc2lkZWJhcl9vbmUiO3M6NzoiY29sdW1ucyI7czoyOiIxMiI7czozMDoiY3NzX3dpZGdldHNfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjIyIjtzOjE5OiJjc3Nfd2lkZ2V0X2JnX2NvbG9yIjtzOjc6IiNmZmZmZmYiO3M6MjM6ImNzc193aWRnZXRfYm9yZGVyX2NvbG9yIjtzOjc6IiNkZWRlZGUiO3M6MjM6ImNzc193aWRnZXRfYm9yZGVyX3dpZHRoIjtzOjE6IjEiO3M6Mjg6ImNzc193aWRnZXRfYm9yZGVyX3JhZGl1c190b3AiO3M6MToiNCI7czozMToiY3NzX3dpZGdldF9ib3JkZXJfcmFkaXVzX2JvdHRvbSI7czoxOiI0IjtzOjI3OiJjc3Nfd2lkZ2V0X3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMzAiO3M6Mjk6ImNzc193aWRnZXRfcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjI3IjtzOjE1OiJ0aXRsZV9mb250X3NpemUiO3M6MjoiMTQiO3M6MjE6ImNzc190aXRsZV9mb250X2ZhbWlseSI7czowOiIiO3M6MTY6ImNzc190aXRsZV9tYXJnaW4iO3M6MjoiMTMiO3M6MTc6ImNzc190aXRsZV9wYWRkaW5nIjtzOjI6IjIwIjtzOjIwOiJjc3NfbWFpbl9saW5lX2hlaWdodCI7czoyOiIyNCI7czoxNDoiY3NzX2xpbmtfY29sb3IiO3M6NzoiI2U2NmU2NSI7czoyMDoiY3NzX2xpbmtfY29sb3JfaG92ZXIiO3M6NzoiI2M3NTg1MCI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjQzO3M6OToibW9kdWxlX2lkIjtzOjEyOiJEU0xDX1dpZGdldHMiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);

	$dslc_var_templates['dslc-projects-ex-1'] = array(
		'title' => __( 'Projects Variation 1', 'dslc_string' ),
		'id' => 'dslc-projects-ex-1',
		'code' => '[dslc_modules_section type="full" columns_spacing="spacing" border_color="" border_width="0" border_style="" border="" bg_color="#f7f6f4" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="" bg_video_overlay_opacity="" bg_image_repeat="no-repeat" bg_image_attachment="parallax" bg_image_position="center bottom" bg_image_size="auto" padding="58" padding_h="5" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="yes" first="no" size="12"] [dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);

	$dslc_var_templates['dslc-projects-ex-2'] = array(
		'title' => __( 'Projects Variation 2', 'dslc_string' ),
		'id' => 'dslc-projects-ex-2',
		'code' => '[dslc_modules_section type="full" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="#f4f9fc" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="no-repeat" bg_image_attachment="scroll" bg_image_position="center center" bg_image_size="auto" padding="61" padding_h="3" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="no" first="yes" size="3"] [dslc_module]YToxOTp7czo0OiJzaXplIjtzOjI6IjEyIjtzOjc6InNpZGViYXIiO3M6MTY6ImRzbGNfc2lkZWJhcl9vbmUiO3M6NzoiY29sdW1ucyI7czoyOiIxMiI7czozMDoiY3NzX3dpZGdldHNfcGFkZGluZ19ob3Jpem9udGFsIjtzOjE6IjMiO3M6MTk6ImNzc193aWRnZXRfYmdfY29sb3IiO3M6NzoiI2ZmZmZmZiI7czoyMzoiY3NzX3dpZGdldF9ib3JkZXJfY29sb3IiO3M6NzoiI2Q5ZDlkOSI7czoyMzoiY3NzX3dpZGdldF9ib3JkZXJfd2lkdGgiO3M6MToiMSI7czoyODoiY3NzX3dpZGdldF9ib3JkZXJfcmFkaXVzX3RvcCI7czoxOiIzIjtzOjMxOiJjc3Nfd2lkZ2V0X2JvcmRlcl9yYWRpdXNfYm90dG9tIjtzOjE6IjMiO3M6Mjc6ImNzc193aWRnZXRfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIzMyI7czoyOToiY3NzX3dpZGdldF9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMzQiO3M6MjQ6ImNzc193aWRnZXRfbWFyZ2luX2JvdHRvbSI7czoyOiIzMiI7czoyMToiY3NzX3RpdGxlX2xpbmVfaGVpZ2h0IjtzOjI6IjE2IjtzOjE2OiJjc3NfdGl0bGVfbWFyZ2luIjtzOjI6IjE0IjtzOjE3OiJjc3NfdGl0bGVfcGFkZGluZyI7czoyOiIxOCI7czoxNDoiY3NzX2xpbmtfY29sb3IiO3M6NzoiIzE2YThmNyI7czoyMDoiY3NzX2xpbmtfY29sb3JfaG92ZXIiO3M6NzoiIzE2ODljNyI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjQ3O3M6OToibW9kdWxlX2lkIjtzOjEyOiJEU0xDX1dpZGdldHMiO30=[/dslc_module] [/dslc_modules_area] [dslc_modules_area last="yes" first="no" size="9"] [dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);		

	$dslc_var_templates['dslc-partners-ex-1'] = array(
		'title' => __( 'Partners Variation 1', 'dslc_string' ),
		'id' => 'dslc-partners-ex-1',
		'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="" bg_image_thumb="disabled" bg_image="http://livecomposerplugin.com/sandbox/wp-content/uploads/sites/3/2013/11/bg2.jpg" bg_video="" bg_video_overlay_color="#111e2e" bg_video_overlay_opacity="0.56" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="114" padding_h="0" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="yes" first="no" size="12"] [dslc_module]YToyMjp7czoxNToicGFnaW5hdGlvbl90eXBlIjtzOjg6Im51bWJlcmVkIjtzOjMxOiJjc3NfdGh1bWJuYWlsX2JvcmRlcl9yYWRpdXNfdG9wIjtzOjE6IjMiO3M6Mjc6ImNzc190aHVtYm5haWxfbWFyZ2luX2JvdHRvbSI7czoxOiIwIjtzOjE4OiJ0aHVtYl9yZXNpemVfd2lkdGgiO3M6MzoiMjc0IjtzOjE3OiJjc3NfbWFpbl9iZ19jb2xvciI7czo3OiIjMWRjMjY3IjtzOjI5OiJjc3NfbWFpbl9ib3JkZXJfcmFkaXVzX2JvdHRvbSI7czoxOiIzIjtzOjI1OiJjc3NfbWFpbl9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjI1IjtzOjI3OiJjc3NfbWFpbl9wYWRkaW5nX2hvcml6b250YWwiO3M6MjoiMzAiO3M6MTk6ImNzc19tYWluX3RleHRfYWxpZ24iO3M6NjoiY2VudGVyIjtzOjE1OiJjc3NfdGl0bGVfY29sb3IiO3M6NzoiI2ZmZmZmZiI7czoxOToiY3NzX3RpdGxlX2ZvbnRfc2l6ZSI7czoyOiIxNiI7czoxNzoiY3NzX2V4Y2VycHRfY29sb3IiO3M6NzoiI2JhZjVkNCI7czoyMzoiY3NzX2V4Y2VycHRfbGluZV9oZWlnaHQiO3M6MjoiMjEiO3M6Mjg6ImNzc19wYWdfaXRlbV9iZ19jb2xvcl9hY3RpdmUiO3M6NzoiIzFkYzI2NyI7czozMjoiY3NzX3BhZ19pdGVtX2JvcmRlcl9jb2xvcl9hY3RpdmUiO3M6NzoiIzFkYzI2NyI7czoxNDoicmVzX3NtX2NvbHVtbnMiO3M6NDoiYXV0byI7czoxMjoicmVzX3NtX3RodW1iIjtzOjU6ImJsb2NrIjtzOjE0OiJyZXNfdHBfY29sdW1ucyI7czo0OiJhdXRvIjtzOjEzOiJyZXNfcF9jb2x1bW5zIjtzOjQ6ImF1dG8iO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo0OTtzOjc6InBvc3RfaWQiO3M6MzoiNDU1IjtzOjk6Im1vZHVsZV9pZCI7czoxMzoiRFNMQ19QYXJ0bmVycyI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);

	$dslc_var_templates['dslc-products-ex-1'] = array(
		'title' => __( 'Products Variation 1', 'dslc_string' ),
		'id' => 'dslc-products-ex-1',
		'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="bottom " bg_color="" bg_image_thumb="disabled" bg_image="http://livecomposerplugin.com/sandbox/wp-content/uploads/sites/3/2014/01/vinyl2.jpg" bg_video="" bg_video_overlay_color="#5d5361" bg_video_overlay_opacity="0.81" bg_image_repeat="no-repeat" bg_image_attachment="scroll" bg_image_position="center center" bg_image_size="auto" padding="95" padding_h="9" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="no" first="yes" size="9"] [dslc_module]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[/dslc_module] [/dslc_modules_area] [dslc_modules_area last="yes" first="no" size="3"] [dslc_module]YToxNjp7czo3OiJzaWRlYmFyIjtzOjE2OiJkc2xjX3NpZGViYXJfb25lIjtzOjc6ImNvbHVtbnMiO3M6MjoiMTIiO3M6MjA6ImNzc193aWRnZXRzX2JnX2NvbG9yIjtzOjc6IiMyZTI4MmUiO3M6Mjg6ImNzc193aWRnZXRzX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMzQiO3M6MzA6ImNzc193aWRnZXRzX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIzMSI7czoyNDoiY3NzX3dpZGdldF9tYXJnaW5fYm90dG9tIjtzOjI6IjM4IjtzOjIyOiJjc3NfdGl0bGVfYm9yZGVyX2NvbG9yIjtzOjc6IiM0NzQxNDciO3M6MTU6ImNzc190aXRsZV9jb2xvciI7czo3OiIjZGJkYmRiIjtzOjE2OiJjc3NfdGl0bGVfbWFyZ2luIjtzOjI6IjE1IjtzOjE3OiJjc3NfdGl0bGVfcGFkZGluZyI7czoyOiIyMSI7czoxNDoiY3NzX21haW5fY29sb3IiO3M6NzoiIzljOTM5YyI7czoxNDoiY3NzX2xpbmtfY29sb3IiO3M6NzoiI2Q5YmI4MCI7czoyMDoiY3NzX2xpbmtfY29sb3JfaG92ZXIiO3M6NzoiI2ViYjU1MiI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjUxO3M6NzoicG9zdF9pZCI7czozOiI0NDkiO3M6OToibW9kdWxlX2lkIjtzOjEyOiJEU0xDX1dpZGdldHMiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);

	$dslc_var_templates['dslc-products-ex-2'] = array(
		'title' => __( 'Products Variation 2', 'dslc_string' ),
		'id' => 'dslc-products-ex-2',
		'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="bottom " bg_color="#78373c" bg_image_thumb="disabled" bg_image="http://livecomposerplugin.com/sandbox/wp-content/uploads/sites/3/2014/01/1.jpg" bg_video="" bg_video_overlay_color="#4d4d4d" bg_video_overlay_opacity="0.77" bg_image_repeat="no-repeat" bg_image_attachment="scroll" bg_image_position="center center" bg_image_size="auto" padding="69" padding_h="9" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="no" first="yes" size="5"] [dslc_module]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[/dslc_module] [/dslc_modules_area] [dslc_modules_area last="no" first="no" size="1"] [/dslc_modules_area] [dslc_modules_area last="yes" first="no" size="6"] [dslc_module]YTo1OntzOjY6ImhlaWdodCI7czoyOiI0MSI7czo1OiJzdHlsZSI7czo5OiJpbnZpc2libGUiO3M6MTg6Im1vZHVsZV9pbnN0YW5jZV9pZCI7aTo1MztzOjc6InBvc3RfaWQiO3M6MzoiNDUxIjtzOjk6Im1vZHVsZV9pZCI7czoxNDoiRFNMQ19TZXBhcmF0b3IiO30=[/dslc_module] [dslc_module]YTo5OntzOjc6ImNvbnRlbnQiO3M6Mjg6IlNlY3Rpb24gZm9yIHByb2R1Y3Qgc2hvd2Nhc2UiO3M6MTc6ImNzc19tYXJnaW5fYm90dG9tIjtzOjI6IjM2IjtzOjE0OiJjc3NfbWFpbl9jb2xvciI7czo3OiIjZmZmZmZmIjtzOjE4OiJjc3NfbWFpbl9mb250X3NpemUiO3M6MjoiMzkiO3M6MjA6ImNzc19tYWluX2ZvbnRfd2VpZ2h0IjtzOjM6IjMwMCI7czoyMDoiY3NzX21haW5fZm9udF9mYW1pbHkiO3M6NzoiUmFsZXdheSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjU0O3M6NzoicG9zdF9pZCI7czozOiI0NTEiO3M6OToibW9kdWxlX2lkIjtzOjE2OiJEU0xDX1RleHRfU2ltcGxlIjt9[/dslc_module] [dslc_module]YTo5OntzOjc6ImNvbnRlbnQiO3M6MTA3NDoiVXQgZW5pbSBhZCBtaW5pbSB2ZW5pYW0sIHF1aXMgbm9zdHJ1ZCBleGVyY2l0YXRpb24gdWxsYW1jbyBsYWJvcmlzIG5pc2kgdXQgYWxpcXVpcCBleCBlYSBjb21tb2RvIGNvbnNlcXVhdC4mbmJzcDs8ZGl2Pjxicj48L2Rpdj48ZGl2PjxzcGFuIHN0eWxlPVwiZm9udC1mYW1pbHk6IE11bGk7IGZvbnQtc2l6ZTogMTZweDsgZm9udC1zdHlsZTogbm9ybWFsOyBmb250LXZhcmlhbnQ6IG5vcm1hbDsgbGluZS1oZWlnaHQ6IDI3cHg7XCI+RHVpcyBhdXRlIGlydXJlIGRvbG9yIGluIHJlcHJlaGVuZGVyaXQgaW4gdm9sdXB0YXRlIHZlbGl0IGVzc2UgY2lsbHVtIGRvbG9yZSBldSBmdWdpYXQgbnVsbGEgcGFyaWF0dXIuIEV4Y2VwdGV1ciBzaW50IG9jY2FlY2F0IGN1cGlkYXRhdCBub24gcHJvaWRlbnQsIHN1bnQgaW4gY3VscGEgcXVpIG9mZmljaWEgZGVzZXJ1bnQgbW9sbGl0IGFuaW0gaWQgZXN0IGxhYm9ydW0uPC9zcGFuPjxicj48L2Rpdj48ZGl2PjxzcGFuIHN0eWxlPVwiZm9udC1mYW1pbHk6IE11bGk7IGZvbnQtc2l6ZTogMTZweDsgZm9udC1zdHlsZTogbm9ybWFsOyBmb250LXZhcmlhbnQ6IG5vcm1hbDsgbGluZS1oZWlnaHQ6IDI3cHg7XCI+PGJyPjwvc3Bhbj48L2Rpdj48ZGl2PjxzcGFuIHN0eWxlPVwiZm9udC1mYW1pbHk6IE11bGk7IGZvbnQtc2l6ZTogMTZweDsgZm9udC1zdHlsZTogbm9ybWFsOyBmb250LXZhcmlhbnQ6IG5vcm1hbDsgbGluZS1oZWlnaHQ6IDI3cHg7XCI+QXV0ZSBpcnVyZSBkb2xvciBpbiByZXByZWhlbmRlcml0IGluIHZvbHVwdGF0ZSB2ZWxpdCBlc3NlIGNpbGx1bSBkb2xvcmUgZXUgZnVnaWF0IG51bGxhIHBhcmlhdHVyLiBFeGNlcHRldXIgc2ludCBvY2NhZWNhdCBjdXBpZGF0YXQgbm9uIHByb2lkZW50LCBzdW50IGluIGN1bHBhIHF1aSBvZmZpY2lhIGRlc2VydW50IG1vbGxpdCBhbmltIGlkIGVzdCBsYWJvcnVtLjwvc3Bhbj48c3BhbiBzdHlsZT1cImZvbnQtZmFtaWx5OiBNdWxpOyBmb250LXNpemU6IDE2cHg7IGZvbnQtc3R5bGU6IG5vcm1hbDsgZm9udC12YXJpYW50OiBub3JtYWw7IGxpbmUtaGVpZ2h0OiAyN3B4O1wiPjxicj48L3NwYW4+PC9kaXY+IjtzOjE3OiJjc3NfbWFyZ2luX2JvdHRvbSI7czoyOiI0MSI7czoxNDoiY3NzX21haW5fY29sb3IiO3M6NzoiI2M3YzdjNyI7czoxODoiY3NzX21haW5fZm9udF9zaXplIjtzOjI6IjE2IjtzOjIwOiJjc3NfbWFpbl9mb250X2ZhbWlseSI7czo0OiJNdWxpIjtzOjIwOiJjc3NfbWFpbl9saW5lX2hlaWdodCI7czoyOiIyNyI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtpOjU1O3M6NzoicG9zdF9pZCI7czozOiI0NTEiO3M6OToibW9kdWxlX2lkIjtzOjE2OiJEU0xDX1RleHRfU2ltcGxlIjt9[/dslc_module] [dslc_module]YToxMjp7czoxMToiYnV0dG9uX3RleHQiO3M6MTI6Ik1PUkUgREVUQUlMUyI7czoxMjoiY3NzX2JnX2NvbG9yIjtzOjc6IiNlZDczNGUiO3M6MTg6ImNzc19iZ19jb2xvcl9ob3ZlciI7czo3OiIjZjI3NTUzIjtzOjIwOiJjc3NfcGFkZGluZ192ZXJ0aWNhbCI7czoyOiIxOCI7czoyMjoiY3NzX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIzNSI7czoyMDoiY3NzX2J1dHRvbl9mb250X3NpemUiO3M6MjoiMTYiO3M6MTQ6ImJ1dHRvbl9pY29uX2lkIjtzOjk6ImZpbGUtdGV4dCI7czoxNDoiY3NzX2ljb25fY29sb3IiO3M6NzoiI2ZmYjM5ZSI7czoxNToiY3NzX2ljb25fbWFyZ2luIjtzOjI6IjEwIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTY7czo3OiJwb3N0X2lkIjtzOjM6IjQ1MSI7czo5OiJtb2R1bGVfaWQiO3M6MTE6IkRTTENfQnV0dG9uIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);
	
	$dslc_var_templates['dslc-staff-ex-1'] = array(
		'title' => __( 'Staff Variation 1', 'dslc_string' ),
		'id' => 'dslc-staff-ex-1',
		'code' => '[dslc_modules_section type="wrapped" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="#f4f6f7" bg_image_thumb="disabled" bg_image="http://livecomposerplugin.com/sandbox/wp-content/uploads/sites/3/2014/01/unsplash_52a088bb6fb98_1.jpg" bg_video="" bg_video_overlay_color="#f4f6f7" bg_video_overlay_opacity="0.95" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="center center" bg_image_size="cover" padding="67" padding_h="4" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="yes" first="no" size="12"] [dslc_module]YTozNTp7czoxMzoicG9zdF9lbGVtZW50cyI7czozMToidGh1bWJuYWlsIHNvY2lhbCB0aXRsZSBleGNlcnB0ICI7czoyMjoiY3NzX3RodW1ibmFpbF9iZ19jb2xvciI7czo3OiIjZmZmZmZmIjtzOjIyOiJjc3NfdGh1bWJfYm9yZGVyX2NvbG9yIjtzOjc6IiNlMGUwZTAiO3M6MjI6ImNzc190aHVtYl9ib3JkZXJfd2lkdGgiO3M6MToiMSI7czozMToiY3NzX3RodW1ibmFpbF9ib3JkZXJfcmFkaXVzX3RvcCI7czoxOiIzIjtzOjM0OiJjc3NfdGh1bWJuYWlsX2JvcmRlcl9yYWRpdXNfYm90dG9tIjtzOjE6IjMiO3M6Mjc6ImNzc190aHVtYm5haWxfbWFyZ2luX2JvdHRvbSI7czoyOiIxNyI7czozMDoiY3NzX3RodW1ibmFpbF9wYWRkaW5nX3ZlcnRpY2FsIjtzOjI6IjEwIjtzOjMyOiJjc3NfdGh1bWJuYWlsX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIxMCI7czoxOToidGh1bWJfcmVzaXplX2hlaWdodCI7czozOiIzMDAiO3M6MTg6InRodW1iX3Jlc2l6ZV93aWR0aCI7czozOiIyNTQiO3M6MTk6ImNzc19zb2NpYWxfYmdfY29sb3IiO3M6NzoiIzNkYjBiZiI7czoyODoiY3NzX3NvY2lhbF9ib3JkZXJfcmFkaXVzX3RvcCI7czoxOiIzIjtzOjIxOiJjc3NfbWFpbl9ib3JkZXJfY29sb3IiO3M6NzoiI2UwZTBlMCI7czoyNToiY3NzX21haW5fcGFkZGluZ192ZXJ0aWNhbCI7czoyOiI0MyI7czoyNzoiY3NzX21haW5fcGFkZGluZ19ob3Jpem9udGFsIjtzOjI6IjQzIjtzOjE1OiJjc3NfdGl0bGVfY29sb3IiO3M6NzoiIzU0NTQ1NCI7czoxOToiY3NzX3RpdGxlX2ZvbnRfc2l6ZSI7czoyOiIxNiI7czoyMToiY3NzX3RpdGxlX2ZvbnRfZmFtaWx5IjtzOjE3OiJMaWJyZSBCYXNrZXJ2aWxsZSI7czoyNToiY3NzX3Bvc2l0aW9uX2JvcmRlcl9jb2xvciI7czo3OiIjZGVkZWRlIjtzOjE4OiJjc3NfcG9zaXRpb25fY29sb3IiO3M6NzoiIzNkYjBiZiI7czoyNDoiY3NzX3Bvc2l0aW9uX2ZvbnRfd2VpZ2h0IjtzOjM6IjYwMCI7czoyNDoiY3NzX3Bvc2l0aW9uX2ZvbnRfZmFtaWx5IjtzOjE3OiJDYXJyb2lzIEdvdGhpYyBTQyI7czoyOToiY3NzX3Bvc2l0aW9uX3BhZGRpbmdfdmVydGljYWwiO3M6MjoiMTYiO3M6MTc6ImNzc19leGNlcnB0X2NvbG9yIjtzOjc6IiM5YzljOWMiO3M6MjE6ImNzc19leGNlcnB0X2ZvbnRfc2l6ZSI7czoyOiIxNiI7czoyMzoiY3NzX2V4Y2VycHRfZm9udF9mYW1pbHkiO3M6NDoiTG9yYSI7czoyMzoiY3NzX2V4Y2VycHRfbGluZV9oZWlnaHQiO3M6MjoiMjciO3M6MTQ6InJlc19zbV9jb2x1bW5zIjtzOjQ6ImF1dG8iO3M6MTI6InJlc19zbV90aHVtYiI7czo1OiJibG9jayI7czoxNDoicmVzX3RwX2NvbHVtbnMiO3M6NDoiYXV0byI7czoxMzoicmVzX3BfY29sdW1ucyI7czo0OiJhdXRvIjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NTc7czo3OiJwb3N0X2lkIjtzOjM6IjQ2MSI7czo5OiJtb2R1bGVfaWQiO3M6MTA6IkRTTENfU3RhZmYiO30=[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);

	$dslc_var_templates['dslc-staff-ex-2'] = array(
		'title' => __( 'Staff Variation 2', 'dslc_string' ),
		'id' => 'dslc-staff-ex-2',
		'code' => '[dslc_modules_section type="full" columns_spacing="spacing" border_color="" border_width="0" border_style="solid" border="top bottom" bg_color="#5c7291" bg_image_thumb="disabled" bg_image="" bg_video="" bg_video_overlay_color="#000000" bg_video_overlay_opacity="0" bg_image_repeat="repeat" bg_image_attachment="scroll" bg_image_position="left top" bg_image_size="auto" padding="80" padding_h="7" margin_h="0" margin_b="0" custom_class="" custom_id="" ] [dslc_modules_area last="yes" first="no" size="12"] [dslc_module]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[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] ',
		'section' => 'original'
	);

	$dslc_user_templates = maybe_unserialize ( get_option( 'dslc_templates' ) );
	if ( ! empty ( $dslc_user_templates ) && is_array( $dslc_user_templates ) )
		$dslc_var_templates = array_merge ( $dslc_var_templates, $dslc_user_templates );

	
	/**
	 * Include all the files
	 */

	include DS_LIVE_COMPOSER_ABS . '/includes/other-functions.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/functions.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/display-functions.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/row-system/init.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/ajax.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/shortcodes.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/scripts.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/post-options-framework/post-options-framework.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/plugin-options-framework/plugin-options-framework.php';
	include DSLC_ST_FRAMEWORK_ABS . '/single-templates-framework.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/access-control.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/performance.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/archive-templates.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/tutorials/tutorial.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/styling-presets.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/header-footer.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/search-filter.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/post-templates.php';
	include DS_LIVE_COMPOSER_ABS . '/includes/other.php';

	$cap_page = dslc_get_option( 'lc_min_capability_page', 'dslc_plugin_options_access_control' );
	if ( ! $cap_page ) $cap_page = 'publish_posts';
	define( 'DS_LIVE_COMPOSER_CAPABILITY', $cap_page );
	define( 'DS_LIVE_COMPOSER_CAPABILITY_SAVE', $cap_page );

	/**
	 * Include Modules
	 */

	include DS_LIVE_COMPOSER_ABS . '/includes/class.module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/posts/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/blog/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/projects/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/galleries/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/infobox/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/staff/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/woocommerce/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/separator/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/downloads/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/testimonials/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/text-simple/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/html/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tabs/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/sliders/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/partners/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/widgets/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/social/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/notification/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/button/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/image/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/progress-bars/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/accordion/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-title/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-content/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-excerpt/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-meta/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-downloads-button/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-thumbnail/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-gallery-slider/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-project-slider/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-comments/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-comments-form/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/tp-staff-social/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/icon/module.php';
	include DS_LIVE_COMPOSER_ABS . '/modules/navigation/module.php';
	

	/**
	 * Dashboard Updates
	 */
	//require_once('wp-updates-plugin.php');
	//new WPUpdatesPluginUpdater_390( 'http://wp-updates.com/api/2/plugin', plugin_basename(__FILE__));

	/**
	* Anna Custom
	*/
    	include DS_LIVE_COMPOSER_ABS . '/anna_custom/anna_custom.php';
